/*
 * Decompiled with CFR 0.152.
 */
package com.ytgram.core;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClipboardMonitor
extends Thread {
    private volatile boolean running = false;
    private String lastContent = "";
    private ClipboardListener listener;
    private Clipboard clipboard;
    private static final Pattern URL_PATTERN = Pattern.compile("(https?://)?(www\\.)?(youtube\\.com/watch\\?v=|youtu\\.be/|youtube\\.com/shorts/|vimeo\\.com/|dailymotion\\.com/|twitter\\.com/|x\\.com/|twitch\\.tv/|tiktok\\.com/|instagram\\.com/|reddit\\.com/|streamable\\.com/|soundcloud\\.com/)[^\\s]+", 2);

    public ClipboardMonitor(ClipboardListener clipboardListener) {
        this.listener = clipboardListener;
        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.setDaemon(true);
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            try {
                String string;
                Transferable transferable = this.clipboard.getContents(null);
                if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor) && (string = (String)transferable.getTransferData(DataFlavor.stringFlavor)) != null && !string.equals(this.lastContent)) {
                    this.lastContent = string;
                    Matcher matcher = URL_PATTERN.matcher(string.trim());
                    if (matcher.find()) {
                        Object object = matcher.group(0);
                        if (!((String)object).startsWith("http://") && !((String)object).startsWith("https://")) {
                            object = "https://" + (String)object;
                        }
                        this.listener.onUrlDetected((String)object);
                    }
                }
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                this.running = false;
            }
            catch (Exception exception) {}
        }
    }

    public void stopMonitoring() {
        this.running = false;
        this.interrupt();
    }

    public boolean isRunning() {
        return this.running;
    }

    public static interface ClipboardListener {
        public void onUrlDetected(String var1);
    }
}

